package com.bxm.lovelink.common.dal.manager.parameter.builders;

import com.bxm.lovelink.common.dal.entity.UserComposite;
import com.bxm.lovelink.common.dal.manager.parameter.ParameterBuilder;
import com.bxm.lovelink.common.dal.manager.parameter.ParameterBuilderRequest;
import org.springframework.stereotype.Service;

/**
 * @author Allen Hu
 * @date 2025/7/9
 */
@Service
public class GenderBuilder implements ParameterBuilder {
    @Override
    public String key() {
        return "gender";
    }

    @Override
    public Object apply(ParameterBuilderRequest parameterBuilderRequest) {
        UserComposite me = parameterBuilderRequest.getMe();
        if (me == null) {
            // 找不到用户默认女性
            return 0;
        }
        return me.getUserBasicInfo().getGender();
    }
}
