package com.bxm.lovelink.common.dal.manager.welcome;

import com.bxm.warcar.integration.listeners.AbstractBeanBus;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.RandomUtils;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/**
 * @author Allen Hu
 * @date 2025/7/1
 */
@Component
public class WelcomeBuilderFactory extends AbstractBeanBus<WelcomeScene, WelcomeBuilder> {
    @Override
    protected Class<WelcomeBuilder> getInstanceClazz() {
        return WelcomeBuilder.class;
    }

    @Override
    protected WelcomeScene getKey(String beanName, WelcomeBuilder bean) {
        return bean.of();
    }

    public List<String> build(WelcomeBuilderRequest request) {
        List<String> result = new ArrayList<>();
        Collection<WelcomeBuilder> builders = getAll();
        for (WelcomeBuilder builder : builders) {
            List<String> res = builder.build(request);
            if (CollectionUtils.isEmpty(res)) {
                continue;
            }
            // 随机取一个
            String msg = res.get(RandomUtils.nextInt(0, res.size()));
            result.add(msg);
        }
        return result;
    }
}
