package com.bxm.lovelink.common.dal.manager.welcome.builders;

import com.bxm.lovelink.common.dal.manager.welcome.WelcomeBuilder;
import com.bxm.lovelink.common.dal.manager.welcome.WelcomeBuilderRequest;
import com.bxm.lovelink.common.dal.manager.welcome.WelcomeScene;
import com.google.common.collect.Lists;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author Allen Hu
 * @date 2025/7/1
 */
@Service
public class ABuilder implements WelcomeBuilder {

    private final static List<String> WELCOME_A = Lists.newArrayList(
            "帮我分析一下我的资料有哪些可以提升的地方？",
            "第一次见面要注意什么？",
            "如何优雅地开启和Ta的第一个话题？",
            "我的性格（MBTI）和哪种类型的人更搭？"
    );

    @Override
    public WelcomeScene of() {
        return WelcomeScene.A;
    }

    @Override
    public List<String> build(WelcomeBuilderRequest request) {
        return WELCOME_A;
    }
}
