package com.bxm.lovelink.common.dal.manager.welcome.builders;

import com.bxm.lovelink.common.dal.manager.welcome.WelcomeBuilder;
import com.bxm.lovelink.common.dal.manager.welcome.WelcomeBuilderRequest;
import com.bxm.lovelink.common.dal.manager.welcome.WelcomeScene;
import com.google.common.collect.Lists;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author Allen Hu
 * @date 2025/7/1
 */
@Service
public class BBuilder implements WelcomeBuilder {

    private final static List<String> WELCOME_A = Lists.newArrayList(
            "现在给我推的用户都不太合适，怎么办？",
            "怎么发起‘约见面’？",
            "‘心动’和‘喜欢’有什么区别？",
            "担心聊天中隐私会泄露，你们有什么保护措施吗？"
    );

    @Override
    public WelcomeScene of() {
        return WelcomeScene.B;
    }

    @Override
    public List<String> build(WelcomeBuilderRequest request) {
        return WELCOME_A;
    }
}
