package com.bxm.lovelink.common.dal.manager.welcome.builders;

import com.bxm.lovelink.common.dal.manager.welcome.WelcomeBuilder;
import com.bxm.lovelink.common.dal.manager.welcome.WelcomeBuilderRequest;
import com.bxm.lovelink.common.dal.manager.welcome.WelcomeScene;
import com.google.common.collect.Lists;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author Allen Hu
 * @date 2025/7/1
 */
@Service
public class CBuilder implements WelcomeBuilder {

    private final static List<String> WELCOME_A = Lists.newArrayList(
            "异地恋应该如何维持？",
            "相亲时遇到没眼缘的，该如何礼貌拒绝？",
            "你们平台的用户都是真人的吗？"
    );

    @Override
    public WelcomeScene of() {
        return WelcomeScene.C;
    }

    @Override
    public List<String> build(WelcomeBuilderRequest request) {
        return WELCOME_A;
    }
}
