package com.bxm.lovelink.common.dal.mapper;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bxm.lovelink.common.dal.entity.Activity;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.bxm.lovelink.common.dal.entity.dao.activity.ActivityListDao;
import com.bxm.lovelink.common.dal.entity.dto.activity.ActivityCenterQueryDto;
import com.bxm.lovelink.common.dal.entity.dto.activity.ActivityQueryDto;
import com.bxm.lovelink.common.dal.entity.dto.activity.ActivityListQueryDto;
import com.bxm.lovelink.common.dal.entity.vo.activity.ActivityCenterVo;
import org.apache.ibatis.annotations.Param;

import java.time.LocalDateTime;
import java.util.List;

/**
 * <p>
 * 活动表 Mapper 接口
 * </p>
 *
 * @author dll
 * @since 2025-06-23
 */
public interface ActivityMapper extends BaseMapper<Activity> {

    List<ActivityListDao> registeredList(@Param("userId") Long userId, @Param("dto") ActivityListQueryDto dto, @Param("now") LocalDateTime now);

    Page<ActivityListDao> list(@Param("userId") Long userId, Page page, @Param("typeIdList") List<Integer> typeIdList, @Param("dto") ActivityQueryDto dto, @Param("visibleActivityIds") List<Long> visibleActivityIds, @Param("now") LocalDateTime now);

    void  updateGuestRecommend(@Param("id") Long id,@Param("guestRecommend") String guestRecommend);


    /**
     * 根据dto查询消息
     *
     * @param page
     * @param dto
     * @return
     */
    IPage<ActivityCenterVo> selectByDto(IPage<ActivityCenterVo> page, @Param("dto") ActivityCenterQueryDto dto);

    int tryUpdateMaleCount(@Param("id") Long id);

    int tryUpdateFemaleCount(@Param("id") Long id);

    int lockDiscountRegisterCount(@Param("id") Long id);

    int incrementDiscountRegisterCount(@Param("id") Long id);

    int releaseDiscountRegisterCount(@Param("id") Long id);

    List<Long> selectVisibleActivityId(@Param("unionid") String unionid);

    List<ActivityListDao> myList(@Param("userId") Long userId, @Param("dto") ActivityListQueryDto dto, @Param("now") LocalDateTime now);

    int releaseMaleRegisterCount(@Param("id") Long id);

    int releaseFemaleRegisterCount(@Param("id") Long id);

    List<Long> selectActivityIdByOrganizerIds(@Param("organizerIds") List<Long> organizerIds);

    Page<ActivityListDao> listWithOutLogin(Page page, @Param("typeIdList") List<Integer> typeIdList, @Param("dto") ActivityQueryDto dto, @Param("now") LocalDateTime now);

    /**
     * 判断某个性别是否还能报名
     * @param activityId 活动ID
     * @param gender 性别：1=男，2=女
     * @return 1表示可以报名，null表示不能报名
     */
    Integer canRegister(@Param("activityId") Long activityId, @Param("gender") Integer gender);
}
