package com.bxm.lovelink.common.dal.mapper;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.bxm.lovelink.common.dal.entity.ActivityRegistration;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.bxm.lovelink.common.dal.entity.dao.activity.ActivityUserDao;
import com.bxm.lovelink.common.dal.entity.dto.activity.registration.ActivityRegistrationQueryDto;
import com.bxm.lovelink.common.dal.entity.dto.activity.usermutualselection.ActivityMutualSelectionQueryDto;
import com.bxm.lovelink.common.dal.entity.vo.activity.registration.ActivityRegistrationVo;
import com.bxm.lovelink.common.dal.entity.vo.activity.registration.ActivityUserRegistrationVo;
import com.bxm.lovelink.common.dal.entity.vo.activity.usermutualselection.ActivityUserVo;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * <p>
 * 活动报名表 Mapper 接口
 * </p>
 *
 * @author dll
 * @since 2025-06-24
 */
public interface ActivityRegistrationMapper extends BaseMapper<ActivityRegistration> {
    /**
     * 根据dto查询消息
     *
     * @param page
     * @param dto
     * @return
     */
    IPage<ActivityRegistrationVo> selectByDto(IPage<ActivityRegistrationVo> page, @Param("dto") ActivityRegistrationQueryDto dto);


    void updateCount(@Param("gender") Integer gender,
                     @Param("discountApplied") Integer discountApplied,
                     @Param("activityId") Long activityId);

    /**
     * 查询活动互选用户列表
     */
    List<ActivityUserDao> selectActivityUserList(@Param("dto") ActivityMutualSelectionQueryDto dto, @Param("gender") Integer gender, @Param("userId") Long userId);


    List<ActivityUserRegistrationVo> guestRecommendList(@Param("dto") ActivityRegistrationQueryDto dto);


    /**
     * 根据活动ID列表查找对应的报名人数
     * @param idsList
     * @return
     */
    List<ActivityUserVo> regiactivityUserList(@Param("idsList") List<Long> idsList);
}
