package com.bxm.lovelink.common.dal.mapper;

import com.bxm.lovelink.common.dal.entity.MeetGroupMessage;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.bxm.lovelink.common.dal.entity.dao.MeetGroupMessageMaxId;
import com.bxm.lovelink.common.dal.entity.dao.MeetGroupUnreadMessageCountDao;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * <p>
 * 见面群聊天记录 Mapper 接口
 * </p>
 *
 * @author allen
 * @since 2025-05-13
 */
public interface MeetGroupMessageMapper extends BaseMapper<MeetGroupMessage> {

    List<MeetGroupMessage> queryNewMessages(@Param("userId") Long userId,
                                            @Param("meetGroupId") Long meetGroupId);

    @Deprecated
    List<MeetGroupUnreadMessageCountDao> countUnreadOnMessages(@Param("userId") Long userId,
                                                               @Param("meetGroupIds") Long[] meetGroupIds);

    Integer countUnreadOnMeetGroup(@Param("userId") Long userId);

    List<MeetGroupMessageMaxId> queryMaxIdOnMeetGroup(@Param("meetGroupIds") Long[] meetGroupIds);
}
