package com.bxm.lovelink.common.dal.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bxm.lovelink.common.dal.entity.UserBasicInfo;
import com.bxm.lovelink.common.dal.entity.UserComposite;
import com.bxm.lovelink.common.dal.entity.dto.activity.usermutualselection.ActivityMutualSelectionQueryDto;
import com.bxm.lovelink.common.dal.entity.dto.user.UserQueryDto;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * <p>
 * 用户的基本信息 Mapper 接口
 * </p>
 *
 * @author zhangdong
 * @since 2025-05-15
 */
public interface UserBasicInfoMapper extends BaseMapper<UserBasicInfo> {

    /**
     * 查询推荐列表
     */
    Page<UserComposite> queryRecommendList(Page<UserComposite> page, @Param("userId") Long userId, @Param("gender") Integer gender);

    Page<UserComposite> queryList(Page<Object> page, @Param("dto")UserQueryDto dto);

    List<UserComposite> selectByIds(@Param("userIds") List<Long> userIds);

    /**
     * 查询活动互选用户组合信息列表
     */
    List<UserComposite> selectActivityUserList(@Param("dto") ActivityMutualSelectionQueryDto dto, @Param("gender") Integer gender, @Param("userId") Long userId);

    List<UserBasicInfo> listIncludeDeleted(@Param("userIds") List<Long> userIds);
}
