package com.bxm.lovelink.common.dal.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bxm.lovelink.common.dal.entity.UserRelation;
import com.bxm.lovelink.common.dal.entity.dao.heartbeat.HeartBeatCountDao;
import com.bxm.lovelink.common.dal.entity.dao.heartbeat.HeartBeatLisDao;
import com.bxm.lovelink.common.dal.entity.dto.heartbeat.HeartBeatQueryDto;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * <p>
 *  用户关系 Mapper 接口
 * </p>
 *
 * @author  weixing
 */
public interface UserRelationMapper extends BaseMapper<UserRelation> {

    List<HeartBeatLisDao> queryMyHeartBeatList(@Param("dto")HeartBeatQueryDto dto, @Param("offset") Integer offset, @Param("size") Integer size);

    List<HeartBeatLisDao> queryHeartBeatMeList(@Param("dto")HeartBeatQueryDto dto, @Param("offset") Integer offset, @Param("size") Integer size);

    Integer countHeartBeatMeList(@Param("dto") HeartBeatQueryDto dto);

    Integer countMyHeartBeatList(@Param("dto") HeartBeatQueryDto dto);

    HeartBeatCountDao selectHeartBeatCounts(@Param("userId") Long userId);
}
