package com.bxm.lovelink.common.dal.mapper;

import com.bxm.lovelink.common.dal.entity.UserVisitRecord;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.bxm.lovelink.common.dal.entity.dao.visit.UserVisitCountDao;
import com.bxm.lovelink.common.dal.entity.dao.visit.UserVisitorListDao;
import com.bxm.lovelink.common.dal.entity.dto.visit.VisitorQueryDto;
import org.apache.ibatis.annotations.Param;

import java.time.LocalDateTime;
import java.util.List;

/**
 * <p>
 * 用户访问记录表 Mapper 接口
 * </p>
 *
 * @author weixing
 * @since 2025-07-23
 */
public interface UserVisitRecordMapper extends BaseMapper<UserVisitRecord> {

    Integer updateVisitCountAndTime(@Param("id") Long id, @Param("time") LocalDateTime time);

    Integer countVisitorList(@Param("dto") VisitorQueryDto dto);

    List<UserVisitorListDao> visitorList(@Param("dto") VisitorQueryDto dto, @Param("offset") Integer offset, @Param("size") Integer size);

    UserVisitCountDao selectUserVisitCount(@Param("userId") Long userId);
}
