package com.bxm.lovelink.common.dal.mapping;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bxm.lovelink.common.dal.entity.AiChannel;
import com.bxm.lovelink.common.dal.entity.dto.channel.AiChannelDto;
import com.bxm.lovelink.common.dal.entity.vo.channel.AiChannelVo;
import org.mapstruct.IterableMapping;
import org.mapstruct.Mapper;
import org.mapstruct.factory.Mappers;

/**
 * @author dll
 * @date 2024/5/09
 * @since 1.0.0
 */
@Mapper
public interface AiChannelMapping {

    AiChannelMapping INSTANCE = Mappers.getMapper(AiChannelMapping.class);

    /**
     * do to vo
     *
     * @param page
     * @return
     */
    @IterableMapping(elementTargetType = AiChannelVo.class)
    Page<AiChannelVo> toPage(IPage<AiChannel> page);

    /**
     * dto to do
     *
     * @param dto
     * @return
     */
    AiChannel dtoToDo(AiChannelDto dto);

    /**
     * do to vo
     * @param category
     * @return
     */
    AiChannelVo doToVo(AiChannel category);
}
