package com.bxm.lovelink.common.dal.mapping;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bxm.lovelink.common.dal.entity.AiApplication;
import com.bxm.lovelink.common.dal.entity.dto.application.AiApplacationDto;
import com.bxm.lovelink.common.dal.entity.vo.application.AiApplacationVo;
import org.mapstruct.IterableMapping;
import org.mapstruct.Mapper;
import org.mapstruct.factory.Mappers;

/**
 * @author dll
 * @date 2024/4/29
 * @since 1.0.0
 */
@Mapper
public interface ApplicationMapping {

    ApplicationMapping INSTANCE = Mappers.getMapper(ApplicationMapping.class);

    /**
     * do to vo
     *
     * @param page
     * @return
     */
    @IterableMapping(elementTargetType = AiApplacationVo.class)
    Page<AiApplacationVo> toPage(IPage<AiApplication> page);

    /**
     * dto to do
     *
     * @param dto
     * @return
     */
    AiApplication dtoToDo(AiApplacationDto dto);

    /**
     * do to vo
     * @param category
     * @return
     */
    //AppCategoryVo doToVo(AppCategory category);
}
