package com.bxm.lovelink.common.dal.mapping;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bxm.lovelink.common.dal.entity.ChatSessionMessage;
import com.bxm.lovelink.common.dal.entity.dao.ChatSessionDao;
import com.bxm.lovelink.common.dal.entity.vo.chat.ChatSessionMessageVo;
import com.bxm.lovelink.common.dal.entity.vo.chat.ChatSessionVo;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Generated;

@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2025-07-28T19:01:23+0800",
    comments = "version: 1.4.2.Final, compiler: javac, environment: Java 1.8.0_422 (Azul Systems, Inc.)"
)
public class ChatSessionMappingImpl implements ChatSessionMapping {

    @Override
    public ChatSessionVo toVoDyDao(ChatSessionDao entity) {
        if ( entity == null ) {
            return null;
        }

        ChatSessionVo chatSessionVo = new ChatSessionVo();

        chatSessionVo.setId( entity.getId() );
        chatSessionVo.setUserId( entity.getUserId() );
        chatSessionVo.setUserAvatar( entity.getUserAvatar() );
        chatSessionVo.setUserNickname( entity.getUserNickname() );
        chatSessionVo.setSessionName( entity.getSessionName() );
        chatSessionVo.setLastMessageContent( entity.getLastMessageContent() );
        chatSessionVo.setLastMessageTime( entity.getLastMessageTime() );

        return chatSessionVo;
    }

    @Override
    public List<ChatSessionVo> toVosDyDao(List<ChatSessionDao> entity) {
        if ( entity == null ) {
            return null;
        }

        List<ChatSessionVo> list = new ArrayList<ChatSessionVo>( entity.size() );
        for ( ChatSessionDao chatSessionDao : entity ) {
            list.add( toVoDyDao( chatSessionDao ) );
        }

        return list;
    }

    @Override
    public Page<ChatSessionMessageVo> toPage(IPage<ChatSessionMessage> chatSessionMessageIPage) {
        if ( chatSessionMessageIPage == null ) {
            return null;
        }

        Page<ChatSessionMessageVo> page = new Page<ChatSessionMessageVo>();

        page.setPages( chatSessionMessageIPage.getPages() );
        page.setRecords( chatSessionMessageListToChatSessionMessageVoList( chatSessionMessageIPage.getRecords() ) );
        page.setTotal( chatSessionMessageIPage.getTotal() );
        page.setSize( chatSessionMessageIPage.getSize() );
        page.setCurrent( chatSessionMessageIPage.getCurrent() );
        page.setSearchCount( chatSessionMessageIPage.isSearchCount() );
        page.setHitCount( chatSessionMessageIPage.isHitCount() );

        return page;
    }

    @Override
    public ChatSessionMessageVo doToVo(ChatSessionMessage message) {
        if ( message == null ) {
            return null;
        }

        ChatSessionMessageVo chatSessionMessageVo = new ChatSessionMessageVo();

        chatSessionMessageVo.setId( message.getId() );
        chatSessionMessageVo.setSessionId( message.getSessionId() );
        chatSessionMessageVo.setRole( message.getRole() );
        chatSessionMessageVo.setContentType( message.getContentType() );
        chatSessionMessageVo.setReasoningContent( message.getReasoningContent() );
        chatSessionMessageVo.setContent( message.getContent() );
        chatSessionMessageVo.setAttachments( message.getAttachments() );
        chatSessionMessageVo.setCreateTime( message.getCreateTime() );

        return chatSessionMessageVo;
    }

    protected List<ChatSessionMessageVo> chatSessionMessageListToChatSessionMessageVoList(List<ChatSessionMessage> list) {
        if ( list == null ) {
            return null;
        }

        List<ChatSessionMessageVo> list1 = new ArrayList<ChatSessionMessageVo>( list.size() );
        for ( ChatSessionMessage chatSessionMessage : list ) {
            list1.add( doToVo( chatSessionMessage ) );
        }

        return list1;
    }
}
