package com.bxm.lovelink.common.dal.mapping;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bxm.lovelink.common.dal.entity.ChatSessionMessage;
import com.bxm.lovelink.common.dal.entity.dto.chat.ChatDto;
import com.bxm.lovelink.common.dal.entity.vo.chat.ChatSessionMessageVo;
import org.mapstruct.IterableMapping;
import org.mapstruct.Mapper;
import org.mapstruct.factory.Mappers;


/**
 * @author tangxiao
 * @date 2025/7/1
 * @since 1.0.0
 */
@Mapper
public interface ChatSessionMessageMapping {

    ChatSessionMessageMapping INSTANCE = Mappers.getMapper(ChatSessionMessageMapping.class);

    /**
     * do to vo
     *
     * @param page
     * @return
     */
    @IterableMapping(elementTargetType = ChatSessionMessageVo.class)
    Page<ChatSessionMessageVo> toPage(IPage<ChatSessionMessage> page);

    /**
     * do to vo
     * @param message
     * @return
     */
    ChatSessionMessageVo doToVo(ChatSessionMessage message);

    /**
     * dto to do
     *
     * @param dto
     * @return
     */
    ChatSessionMessage dtoToDo(ChatDto dto);
}
