package com.bxm.lovelink.common.dal.mapping;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bxm.lovelink.common.dal.entity.AiEvent;
import com.bxm.lovelink.common.dal.entity.dto.event.AiEventDto;
import com.bxm.lovelink.common.dal.entity.vo.event.AiEventVo;
import org.mapstruct.IterableMapping;
import org.mapstruct.Mapper;
import org.mapstruct.factory.Mappers;


/**
 * @author dll
 * @date 2024/4/29
 * @since 1.0.0
 */
@Mapper
public interface EventMapping {

    EventMapping INSTANCE = Mappers.getMapper(EventMapping.class);

    /**
     * do to vo
     *
     * @param page
     * @return
     */
    @IterableMapping(elementTargetType = AiEventVo.class)
    Page<AiEventVo> toPage(IPage<AiEvent> page);

    /**
     * dto to do
     *
     * @param dto
     * @return
     */
    AiEvent dtoToDo(AiEventDto dto);

    /**
     * do to vo
     * @param category
     * @return
     */
    AiEventVo doToVo(AiEvent category);
}
