package com.bxm.lovelink.common.dal.mapping;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bxm.lovelink.common.dal.entity.AiEventType;
import com.bxm.lovelink.common.dal.entity.dto.event.AiEventTypeDto;
import com.bxm.lovelink.common.dal.entity.vo.event.AiEventTypeVo;
import org.mapstruct.IterableMapping;
import org.mapstruct.Mapper;
import org.mapstruct.factory.Mappers;

/**
 * @author dll
 * @date 2024/4/29
 * @since 1.0.0
 */
@Mapper
public interface EventTypeMapping {

    EventTypeMapping INSTANCE = Mappers.getMapper(EventTypeMapping.class);

    /**
     * do to vo
     *
     * @param page
     * @return
     */
    @IterableMapping(elementTargetType = AiEventTypeVo.class)
    Page<AiEventTypeVo> toPage(IPage<AiEventType> page);

    /**
     * dto to do
     *
     * @param dto
     * @return
     */
    AiEventType dtoToDo(AiEventTypeDto dto);

    /**
     * do to vo
     * @param category
     * @return
     */
    //AppCategoryVo doToVo(AppCategory category);
}
