package com.bxm.lovelink.common.dal.mapping;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bxm.lovelink.common.dal.entity.AiEvent;
import com.bxm.lovelink.common.dal.entity.AiExample;
import com.bxm.lovelink.common.dal.entity.dto.event.AiEventDto;
import com.bxm.lovelink.common.dal.entity.dto.example.AiExampleDto;
import com.bxm.lovelink.common.dal.entity.vo.event.AiEventVo;
import com.bxm.lovelink.common.dal.entity.vo.example.AiExampleVo;
import org.mapstruct.IterableMapping;
import org.mapstruct.Mapper;
import org.mapstruct.factory.Mappers;


/**
 * @author dll
 * @date 2024/4/29
 * @since 1.0.0
 */
@Mapper
public interface ExampleMapping {

    ExampleMapping INSTANCE = Mappers.getMapper(ExampleMapping.class);

    /**
     * do to vo
     *
     * @param page
     * @return
     */
    @IterableMapping(elementTargetType = AiExampleVo.class)
    Page<AiExampleVo> toPage(IPage<AiExample> page);

    /**
     * dto to do
     *
     * @param dto
     * @return
     */
    AiExample dtoToDo(AiExampleDto dto);

    /**
     * do to vo
     * @param category
     * @return
     */
    AiExampleVo doToVo(AiExample category);
}
