package com.bxm.lovelink.common.dal.mapping;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bxm.lovelink.common.dal.entity.dao.heartbeat.HeartBeatLisDao;
import com.bxm.lovelink.common.dal.entity.vo.heartbeat.HeartBeatListVo;
import org.mapstruct.Mapper;
import org.mapstruct.factory.Mappers;

import java.util.stream.Collectors;

@Mapper
public interface HeartBeatMapping {

    HeartBeatMapping INSTANCE = Mappers.getMapper(HeartBeatMapping.class);

    HeartBeatListVo toVo(HeartBeatLisDao dao);

    default Page<HeartBeatListVo> toPage(IPage<HeartBeatLisDao> page) {
        Page<HeartBeatListVo> result = new Page<>();
        result.setCurrent(page.getCurrent());
        result.setSize(page.getSize());
        result.setTotal(page.getTotal());
        result.setPages(page.getPages());
        result.setRecords(page.getRecords().stream().map(this::toVo).collect(Collectors.toList()));
        return result;
    }

}
