package com.bxm.lovelink.common.dal.mapping;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bxm.lovelink.common.dal.entity.AiInterlocutors;
import com.bxm.lovelink.common.dal.entity.AiTemplate;
import com.bxm.lovelink.common.dal.entity.dto.interlocutors.AiInterlocutorsDto;
import com.bxm.lovelink.common.dal.entity.dto.template.AiTemplateDto;
import com.bxm.lovelink.common.dal.entity.vo.interlocutors.AiInterlocutorsVo;
import com.bxm.lovelink.common.dal.entity.vo.template.AiTemplateVo;
import org.mapstruct.IterableMapping;
import org.mapstruct.Mapper;
import org.mapstruct.factory.Mappers;

/**
 * @author dll
 * @date 2024/4/29
 * @since 1.0.0
 */
@Mapper
public interface InterlocutorsMapping {

    InterlocutorsMapping INSTANCE = Mappers.getMapper(InterlocutorsMapping.class);

    /**
     * do to vo
     *
     * @param page
     * @return
     */
    @IterableMapping(elementTargetType = AiInterlocutorsVo.class)
    Page<AiInterlocutorsVo> toPage(IPage<AiInterlocutors> page);

    /**
     * dto to do
     *
     * @param dto
     * @return
     */
    AiInterlocutors dtoToDo(AiInterlocutorsDto dto);

    /**
     * do to vo
     * @param category
     * @return
     */
    //AppCategoryVo doToVo(AppCategory category);
}
