package com.bxm.lovelink.common.dal.mapping;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bxm.lovelink.common.dal.entity.LovelinkAppVersion;
import com.bxm.lovelink.common.dal.entity.dto.version.LovelinkAppVersionDto;
import com.bxm.lovelink.common.dal.entity.vo.version.LovelinkAppVersionVo;
import org.mapstruct.IterableMapping;
import org.mapstruct.Mapper;
import org.mapstruct.factory.Mappers;

/**
 * @author dll
 * @date 2025/5/14
 * @since 1.0.0
 */
@Mapper
public interface LovelinkAppVersionMapping {

    LovelinkAppVersionMapping INSTANCE = Mappers.getMapper(LovelinkAppVersionMapping.class);
    /**
     * do to vo
     *
     * @param page
     * @return
     */
    @IterableMapping(elementTargetType = LovelinkAppVersionVo.class)
    Page<LovelinkAppVersionVo> toPage(IPage<LovelinkAppVersion> page);

    /**
     * dto to do
     *
     * @param dto
     * @return
     */
    LovelinkAppVersion dtoToDo(LovelinkAppVersionDto dto);

    /**
     * do to vo
     * @param category
     * @return
     */
    LovelinkAppVersionVo doToVo(LovelinkAppVersion category);
}
