package com.bxm.lovelink.common.dal.mapping;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bxm.lovelink.common.dal.entity.LovelinkPair;
import com.bxm.lovelink.common.dal.entity.dto.pair.LoveLinkPairDto;
import com.bxm.lovelink.common.dal.entity.vo.pair.LoveLinkPairVo;
import org.mapstruct.IterableMapping;
import org.mapstruct.Mapper;
import org.mapstruct.factory.Mappers;

/**
 * @author dll
 * @date 2025/5/14
 * @since 1.0.0
 */
@Mapper
public interface LovelinkPairMapping {

    LovelinkPairMapping INSTANCE = Mappers.getMapper(LovelinkPairMapping.class);

    /**
     * do to vo
     *
     * @param page
     * @return
     */
    @IterableMapping(elementTargetType = LoveLinkPairVo.class)
    Page<LoveLinkPairVo> toPage(IPage<LovelinkPair> page);

    /**
     * dto to do
     *
     * @param dto
     * @return
     */
    LovelinkPair dtoToDo(LoveLinkPairDto dto);

    /**
     * do to vo
     * @param category
     * @return
     */
    LoveLinkPairVo doToVo(LovelinkPair category);
}
