package com.bxm.lovelink.common.dal.mapping;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bxm.lovelink.common.dal.entity.MeetGroup;
import com.bxm.lovelink.common.dal.entity.MeetGroupMessage;
import com.bxm.lovelink.common.dal.entity.User;
import com.bxm.lovelink.common.dal.entity.UserBasicInfo;
import com.bxm.lovelink.common.dal.entity.dao.MeetGroupDao;
import com.bxm.lovelink.common.dal.entity.vo.meet.MeetGroupMessageQueryVo;
import com.bxm.lovelink.common.dal.entity.vo.meet.MeetGroupQueryVo;
import com.bxm.lovelink.common.dal.entity.vo.meet.MeetUserVo;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.Named;

import java.util.List;

/**
 * @author huxiao
 */
@Mapper
public interface MeetGroupMapping {

    MeetGroupMapping INSTANCE = org.mapstruct.factory.Mappers.getMapper(MeetGroupMapping.class);

    MeetGroupQueryVo toVo(MeetGroup meetGroup);

    @Mapping(target = "inviteUserVo", expression = "java(mapInviteUserVo(meetGroupDao))")
    @Mapping(target = "acceptUserVo", expression = "java(mapAcceptUserVo(meetGroupDao))")
    MeetGroupQueryVo toVoByDao(MeetGroupDao meetGroupDao);

    List<MeetGroupQueryVo> toVoListByDao(List<MeetGroupDao> meetGroupDaoList);

    @Named("mapInviteUserVo")
    default MeetUserVo mapInviteUserVo(MeetGroupDao dao) {
        return mergeUserAndBasicInfo(dao.getInviteUser(), dao.getInviteUserBasicInfo());
    }

    @Named("mapAcceptUserVo")
    default MeetUserVo mapAcceptUserVo(MeetGroupDao dao) {
        return mergeUserAndBasicInfo(dao.getAcceptUser(), dao.getAcceptUserBasicInfo());
    }

    MeetUserVo mergeUserAndBasicInfo(User user, UserBasicInfo userBasicInfo);

    // -------- about message -------- //

    MeetGroupMessageQueryVo toMessageVo(MeetGroupMessage meetGroupMessage);

    List<MeetGroupMessageQueryVo> toMessageVoList(List<MeetGroupMessage> meetGroupMessageList);

    Page<MeetGroupMessageQueryVo> toMessageVoPage(IPage<MeetGroupMessage> page);

}
