package com.bxm.lovelink.common.dal.mapping;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bxm.lovelink.common.dal.entity.MeetTicketProduct;
import com.bxm.lovelink.common.dal.entity.vo.meetticket.TicketProductVo;
import org.mapstruct.IterableMapping;
import org.mapstruct.Mapper;
import org.mapstruct.factory.Mappers;

import java.util.List;


/**
 * @author tangxiao
 * @date 2025/5/16
 * @since 1.0.0
 */
@Mapper
public interface MeetTicketProductMapping {

    MeetTicketProductMapping INSTANCE = Mappers.getMapper(MeetTicketProductMapping.class);

    /**
     * do to vo
     *
     * @param page
     * @return
     */
    @IterableMapping(elementTargetType = TicketProductVo.class)
    Page<TicketProductVo> toPage(IPage<MeetTicketProduct> page);

    @IterableMapping(elementTargetType = TicketProductVo.class)
    List<TicketProductVo> toVoList(List<MeetTicketProduct> meetTicketProducts);

    /**
     * do to vo
     * @param meetTicketProduct
     * @return
     */
    TicketProductVo doToVo(MeetTicketProduct meetTicketProduct);
}
