package com.bxm.lovelink.common.dal.mapping;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bxm.lovelink.common.dal.entity.AiEvent;
import com.bxm.lovelink.common.dal.entity.PushTask;
import com.bxm.lovelink.common.dal.entity.dto.event.AiEventDto;
import com.bxm.lovelink.common.dal.entity.dto.pushtask.PushTaskDto;
import com.bxm.lovelink.common.dal.entity.vo.event.AiEventVo;
import com.bxm.lovelink.common.dal.entity.vo.pushtask.PushTaskVo;
import org.mapstruct.IterableMapping;
import org.mapstruct.Mapper;
import org.mapstruct.factory.Mappers;


/**
 * @author dll
 * @date 2024/4/29
 * @since 1.0.0
 */
@Mapper
public interface PushTaskMapping {

    PushTaskMapping INSTANCE = Mappers.getMapper(PushTaskMapping.class);

    /**
     * do to vo
     *
     * @param page
     * @return
     */
    @IterableMapping(elementTargetType = PushTaskVo.class)
    Page<PushTaskVo> toPage(IPage<PushTask> page);

    /**
     * dto to do
     *
     * @param dto
     * @return
     */
    PushTask dtoToDo(PushTaskDto dto);

    /**
     * do to vo
     *
     * @param category
     * @return
     */
    PushTaskVo doToVo(PushTask category);
}
