package com.bxm.lovelink.common.dal.mapping;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bxm.lovelink.common.dal.entity.AiEventType;
import com.bxm.lovelink.common.dal.entity.AiTemplate;
import com.bxm.lovelink.common.dal.entity.dto.event.AiEventTypeDto;
import com.bxm.lovelink.common.dal.entity.dto.template.AiTemplateDto;
import com.bxm.lovelink.common.dal.entity.vo.event.AiEventTypeVo;
import com.bxm.lovelink.common.dal.entity.vo.template.AiTemplateVo;
import org.mapstruct.IterableMapping;
import org.mapstruct.Mapper;
import org.mapstruct.factory.Mappers;

/**
 * @author dll
 * @date 2024/4/29
 * @since 1.0.0
 */
@Mapper
public interface TemplateMapping {

    TemplateMapping INSTANCE = Mappers.getMapper(TemplateMapping.class);

    /**
     * do to vo
     *
     * @param page
     * @return
     */
    @IterableMapping(elementTargetType = AiTemplateVo.class)
    Page<AiTemplateVo> toPage(IPage<AiTemplate> page);

    /**
     * dto to do
     *
     * @param dto
     * @return
     */
    AiTemplate dtoToDo(AiTemplateDto dto);

    /**
     * do to vo
     * @param category
     * @return
     */
    //AppCategoryVo doToVo(AppCategory category);
}
