package com.bxm.lovelink.common.dal.mapping;

import com.alibaba.fastjson.JSON;
import com.bxm.lovelink.common.contant.UserConstants;
import com.bxm.lovelink.common.dal.entity.*;
import com.bxm.lovelink.common.dal.entity.dto.user.UserCertDto;
import com.bxm.lovelink.common.dal.entity.vo.user.UserCertVo;
import com.bxm.warcar.utils.JsonHelper;
import org.apache.commons.lang3.StringUtils;
import org.mapstruct.Mapper;
import org.mapstruct.factory.Mappers;

import java.util.List;

/**
 * @author zhangdong
 * @date 2025/5/15
 */
@Mapper
public interface UserCertMapping {

    UserCertMapping INSTANCE = Mappers.getMapper(UserCertMapping.class);

    UserCert dtoToDo(UserCertDto dto);

    default UserCertVo doToVo(UserCert cert) {
        if (cert == null) {
            return null;
        }
        UserCertVo vo = new UserCertVo();
        vo.setCertType(cert.getCertType());
        vo.setCertStatus(cert.getCertStatus());
        vo.setCertResult(JsonHelper.convert(cert.getCertResult(), UserCertResult.class));
        vo.setModifyTime(cert.getModifyTime());
        String certContent = cert.getCertContent();
        if (StringUtils.isBlank(certContent)) {
            return vo;
        }
        Class<?> clazz = null;
        UserConstants.CertTypeEnum certType = UserConstants.CertTypeEnum.getCertType(cert.getCertType());
        switch (certType) {
            case REAL_PEOPLE:
                vo.setCertPeople(JSON.parseObject(certContent, UserCertPeople.class));
                break;
            default:
                break;
        }

        return vo;
    }

    List<UserCertVo> doToVo(List<UserCert> cert);


}
