package com.bxm.lovelink.common.dal.mapping;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bxm.lovelink.common.dal.entity.*;
import com.bxm.lovelink.common.dal.entity.dto.user.UserBasicInfoDto;
import com.bxm.lovelink.common.dal.entity.dto.user.UserCompositeDto;
import com.bxm.lovelink.common.dal.entity.dto.user.UserLoveConditionDto;
import com.bxm.lovelink.common.dal.entity.vo.user.*;
import com.bxm.warcar.utils.JsonHelper;
import org.mapstruct.IterableMapping;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.factory.Mappers;

import java.util.List;

/**
 * @author zhangdong
 * @date 2025/5/15
 */
@Mapper
public interface UserInfoMapping {

    UserInfoMapping INSTANCE = Mappers.getMapper(UserInfoMapping.class);

    UserBasicInfo dtoToDo(UserBasicInfoDto dto);

    UserLoveCondition dtoToDo(UserLoveConditionDto dto);

    UserComposite dtoToDo(UserCompositeDto dto);

    UserCompositeVo doToVo(UserComposite entity);

    List<UserCompositeVo> doToVo(List<UserComposite> entity);

    UserVo doToVo(User entity);

    UserBasicInfoVo doToVo(UserBasicInfo entity);

    UserOtherInfoVo doToVo(UserOtherInfo entity);

    UserLoveConditionVo doToVo(UserLoveCondition entity);

    UserCompositeSimpleVo voToVo(UserCompositeVo entity);

    @IterableMapping(elementTargetType = UserCompositeVo.class)
    Page<UserCompositeVo> toUserPage(IPage<UserComposite> page);

    @IterableMapping(elementTargetType = UserCompositeSimpleVo.class)
    Page<UserCompositeSimpleVo> toPage(IPage<UserCompositeVo> page);

    List<UserCompositeSimpleVo> toList(List<UserCompositeVo> compositeVos);

    default UserCertResult map(String value) {
        return JsonHelper.convert(value, UserCertResult.class);
    }

    @Mapping(source = "userId", target = "id")
    com.bxm.lovelink.rs.facade.User toRecommendUser(UserBasicInfo userBasicInfo);
}
