package com.bxm.lovelink.common.dal.mapping;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bxm.lovelink.common.dal.entity.UserMeetTicketRecord;
import com.bxm.lovelink.common.dal.entity.vo.meetticket.TicketProductVo;
import com.bxm.lovelink.common.dal.entity.vo.meetticket.TicketRecordVo;
import org.mapstruct.IterableMapping;
import org.mapstruct.Mapper;
import org.mapstruct.factory.Mappers;


/**
 * @author tangxiao
 * @date 2025/5/16
 * @since 1.0.0
 */
@Mapper
public interface UserMeetTicketRecordMapping {

    UserMeetTicketRecordMapping INSTANCE = Mappers.getMapper(UserMeetTicketRecordMapping.class);

    /**
     * do to vo
     *
     * @param page
     * @return
     */
    @IterableMapping(elementTargetType = TicketProductVo.class)
    Page<TicketRecordVo> toPage(IPage<UserMeetTicketRecord> page);

    /**
     * do to vo
     * @param category
     * @return
     */
    TicketRecordVo doToVo(UserMeetTicketRecord category);
}
