package com.bxm.lovelink.common.dal.mapping.activity;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bxm.lovelink.common.dal.entity.Activity;
import com.bxm.lovelink.common.dal.entity.dao.activity.ActivityListDao;
import com.bxm.lovelink.common.dal.entity.dto.activity.ActivityDto;
import com.bxm.lovelink.common.dal.entity.vo.activity.ActivityDetailVo;
import com.bxm.lovelink.common.dal.entity.vo.activity.ActivityListVo;
import com.bxm.lovelink.common.dal.entity.vo.activity.ActivityVo;
import org.mapstruct.IterableMapping;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.factory.Mappers;

import java.util.List;

/**
 * @author: weixing
 */
@Mapper
public interface ActivityMapping {
    ActivityMapping INSTANCE = Mappers.getMapper(ActivityMapping.class);

    @IterableMapping(elementTargetType = ActivityListVo.class)
    List<ActivityListVo> daoToVoList(List<ActivityListDao> bdStoreDaoList);

    @IterableMapping(elementTargetType = ActivityListVo.class)
    Page<ActivityListVo> daoToVoPage(Page<ActivityListDao> bdStoreDaoPage);

    @IterableMapping(elementTargetType = ActivityListVo.class)
    Page<ActivityListVo> toVoPage(Page<Activity> activityPage);

    ActivityDetailVo toDetailVo(Activity activity);


    Activity dtoToDo(ActivityDto dto);


    @IterableMapping(elementTargetType = ActivityDetailVo.class)
    Page<ActivityVo> toActVoPage(Page<Activity> activityPage);


    ActivityVo actToActVo(Activity activity);

    @IterableMapping(elementTargetType = ActivityListVo.class)
    List<ActivityListVo> toVoList(List<Activity> activityList);
}
