package com.bxm.lovelink.common.dal.mapping.activity;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bxm.lovelink.common.dal.entity.ActivityOrganizer;
import com.bxm.lovelink.common.dal.entity.ActivityType;
import com.bxm.lovelink.common.dal.entity.dto.activity.organizer.ActivityOrganizerDto;
import com.bxm.lovelink.common.dal.entity.dto.activity.type.ActivityTypeDto;
import com.bxm.lovelink.common.dal.entity.vo.activity.organizer.ActivityOrganizerVo;
import com.bxm.lovelink.common.dal.entity.vo.activity.type.ActivityTypeVo;
import org.mapstruct.IterableMapping;
import org.mapstruct.Mapper;
import org.mapstruct.factory.Mappers;

import java.util.List;

/**
 * @author dll
 * @date 2025/6/24
 * @since 1.0.0
 */
@Mapper
public interface ActivityOrganizerMapping {

    ActivityOrganizerMapping INSTANCE = Mappers.getMapper(ActivityOrganizerMapping.class);

    /**
     * do to vo
     *
     * @param page
     * @return
     */
    @IterableMapping(elementTargetType = ActivityOrganizerVo.class)
    Page<ActivityOrganizerVo> toPage(IPage<ActivityOrganizer> page);

    /**
     * dto to do
     *
     * @param dto
     * @return
     */
    ActivityOrganizer dtoToDo(ActivityOrganizerDto dto);

}
