package com.bxm.lovelink.common.dal.mapping.activity;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bxm.lovelink.common.dal.entity.ActivityType;
import com.bxm.lovelink.common.dal.entity.AiEventType;
import com.bxm.lovelink.common.dal.entity.dto.activity.type.ActivityTypeDto;
import com.bxm.lovelink.common.dal.entity.dto.event.AiEventTypeDto;
import com.bxm.lovelink.common.dal.entity.vo.activity.type.ActivityTypeVo;
import com.bxm.lovelink.common.dal.entity.vo.event.AiEventTypeVo;
import org.mapstruct.IterableMapping;
import org.mapstruct.Mapper;
import org.mapstruct.factory.Mappers;

import java.util.List;

/**
 * @author dll
 * @date 2025/6/24
 * @since 1.0.0
 */
@Mapper
public interface ActivityTypeMapping {

    ActivityTypeMapping INSTANCE = Mappers.getMapper(ActivityTypeMapping.class);

    /**
     * do to vo
     *
     * @param page
     * @return
     */
    @IterableMapping(elementTargetType = ActivityTypeVo.class)
    Page<ActivityTypeVo> toPage(IPage<ActivityType> page);

    /**
     * dto to do
     *
     * @param dto
     * @return
     */
    ActivityType dtoToDo(ActivityTypeDto dto);


    @IterableMapping(elementTargetType = ActivityTypeVo.class)
    List<ActivityTypeVo> toList(List<ActivityType> list);
}
