package com.bxm.lovelink.common.dal.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.bxm.lovelink.common.dal.entity.UserBasicInfo;
import com.bxm.lovelink.common.dal.entity.dto.heartbeat.UserClearUnReadDto;
import com.bxm.lovelink.common.dal.entity.dto.heartbeat.HeartBeatDto;
import com.bxm.lovelink.common.dal.entity.dto.heartbeat.HeartBeatQueryDto;
import com.bxm.lovelink.common.dal.entity.dto.heartbeat.HeartBeatReadDto;
import com.bxm.lovelink.common.dal.entity.vo.heartbeat.HeartBeatListVo;
import com.bxm.lovelink.common.dal.entity.vo.heartbeat.HeartBeatResultVo;
import com.bxm.lovelink.common.dal.entity.vo.heartbeat.HeartBeatUnreadCountVo;

/**
 * <p>
 *  心动管理服务类
 * </p>
 *
 * @author  weixing
 */
public interface HeartBeatService {
    /**
     * 我的心动列表
     */
    IPage<HeartBeatListVo> queryMyHeartBeatList(HeartBeatQueryDto dto);

    /**
     * 心动我的列表
     */
    IPage<HeartBeatListVo> queryHeartBeatMeList(HeartBeatQueryDto dto);

    /**
     * 滑动操作（心动/不喜欢）
     */
    HeartBeatResultVo swipe(UserBasicInfo userBasicInfo, HeartBeatDto heartBeatDto);

    /**
     * 未读被心动数量
     */
    Integer unReadCount(Long userId);

    /**
     * 读取心动/访客消息
     */
    void read(Long userId, HeartBeatReadDto heartBeatReadDto);

    HeartBeatUnreadCountVo countUnread(Long userId);

    void clearUnread(Long userId, UserClearUnReadDto dto);
}
