package com.bxm.lovelink.common.dal.service;

import com.bxm.lovelink.common.dal.entity.Activity;
import com.bxm.lovelink.common.dal.entity.ActivityRegistrationData;
import com.bxm.lovelink.common.dal.entity.vo.activity.ActivityPayConfigVo;
import com.bxm.lovelink.common.dal.entity.ActivityRegistration;
import com.baomidou.mybatisplus.extension.service.IService;
import com.bxm.lovelink.common.dal.entity.UserBasicInfo;
import com.bxm.lovelink.common.dal.entity.dto.activity.evaluation.ActivityRegisterDto;
import com.bxm.lovelink.common.dal.entity.vo.activity.registration.ActivityRegistrationResultVo;
import com.bxm.lovelink.common.dal.entity.vo.activity.usermutualselection.ActivityUserVo;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * <p>
 * 活动报名表 服务类
 * </p>
 *
 * @author dll
 * @since 2025-06-24
 */
public interface IActivityRegistrationService extends IService<ActivityRegistration> {

    ActivityRegistrationResultVo register(ActivityRegisterDto dto, UserBasicInfo userBasicInfo);

    BigDecimal calculateActivityPrice(Activity activity, Long userId);

    ActivityRegistration getOneByOrderNo(String orderNo);


    /**
     * 根据活动ID列表查找对应的报名人数
     */
    Map<Long,  List<ActivityUserVo>> getRegiactUserMap(List<Long> activityIdsList);

    void userCancel(Long userId);

    ActivityPayConfigVo getPayConfig();

    Map<Long, ActivityRegistrationData> getActivityRegistrationDataMap(List<Long> activityIdsList);

    Map<Long, ActivityRegistrationData> getActivityRegistrationDataMap(Map<Long,  List<ActivityUserVo>> activityUserMap);
}
