package com.bxm.lovelink.common.dal.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bxm.lovelink.common.dal.entity.Activity;
import com.baomidou.mybatisplus.extension.service.IService;
import com.bxm.lovelink.common.dal.entity.UserBasicInfo;
import com.bxm.lovelink.common.dal.entity.dto.activity.ActivityQueryDto;
import com.bxm.lovelink.common.dal.entity.dto.activity.ActivityListQueryDto;
import com.bxm.lovelink.common.dal.entity.vo.activity.ActivityDetailVo;
import com.bxm.lovelink.common.dal.entity.vo.activity.ActivityListVo;

import java.util.List;

/**
 * <p>
 * 活动表 服务类
 * </p>
 *
 * @author dll
 * @since 2025-06-23
 */
public interface IActivityService extends IService<Activity> {

    List<ActivityListVo> registeredList(Long userId, ActivityListQueryDto dto);

    Page<ActivityListVo> list(Long userId, ActivityQueryDto dto);

    List<ActivityListVo> endList(Long userId, ActivityListQueryDto dto);

    ActivityDetailVo detail(UserBasicInfo userBasicInfo, Long id);

    List<ActivityListVo> myList(Long userId, ActivityListQueryDto dto);

    void releaseStock(String orderNum);

    Page<ActivityListVo> listWithOutLogin(ActivityQueryDto dto);
}
