package com.bxm.lovelink.common.dal.service;

import com.bxm.lovelink.common.dal.entity.ActivityUserMutualSelection;
import com.baomidou.mybatisplus.extension.service.IService;
import com.bxm.lovelink.common.dal.entity.User;
import com.bxm.lovelink.common.dal.entity.UserBasicInfo;
import com.bxm.lovelink.common.dal.entity.dto.activity.usermutualselection.ActivityMutualSelectionQueryDto;
import com.bxm.lovelink.common.dal.entity.vo.activity.usermutualselection.ActivityUserSelectionResultVo;
import com.bxm.lovelink.common.dal.entity.vo.activity.usermutualselection.ActivityUserSelectionStatisticsVo;
import com.bxm.lovelink.common.dal.entity.vo.user.UserCompositeSimpleVo;

import java.util.List;

/**
 * <p>
 * 活动用户互选成功表 服务类
 * </p>
 *
 * @author dll
 * @since 2025-06-23
 */
public interface IActivityUserMutualSelectionService extends IService<ActivityUserMutualSelection> {

    List<UserCompositeSimpleVo> userList(ActivityMutualSelectionQueryDto dto, UserBasicInfo userBasicInfo);

    List<ActivityUserSelectionResultVo> selectResult(Long activityId, UserBasicInfo userBasicInfo, User currentUser);

    Boolean canFreeRegister(Long activityId, UserBasicInfo userBasicInfo);

    void receiveFreeRegister(Long activityId, UserBasicInfo userBasicInfo);

    void generateMutualSelectResult(Long activityId);

    /**
     * 获取用户对另一用户的互选结果，如果已经互选，则返回true，否则返回false
     * @param maleUserId 男生
     * @param femaleUserId 女生
     * @return 如果已经互选，则返回true，否则返回false
     */
    boolean exists(Long maleUserId, Long femaleUserId);

    void deleteUserMutualSelection(Long userId, Integer gender);

    ActivityUserSelectionStatisticsVo statistics(ActivityMutualSelectionQueryDto dto, UserBasicInfo userBasicInfo);
}
