package com.bxm.lovelink.common.dal.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.bxm.lovelink.common.dal.entity.Region;
import com.bxm.lovelink.common.dal.entity.vo.region.RegionVo;

import java.util.List;
import java.util.Map;
import java.util.function.Function;

/**
 * <p>
 * 区域表 服务类
 * </p>
 *
 * @author zhangdong
 * @since 2025-05-17
 */
public interface IRegionService extends IService<Region> {


    List<RegionVo> listByRootChildren();
    List<RegionVo> getByParentCode(Integer parentCode);
    RegionVo listByRoot();

    Map<Integer,String>  queryByCodes(List<Integer> codes);

    /**
     * 优先从缓存里获取所有的区域信息
     * @param valueMapper 缓存值映射
     * @param <U> 缓存值类型
     * @return 区域编码映射
     */
    <U> Map<Integer, U> fetchAll(Function<Region, U> valueMapper);
}
