package com.bxm.lovelink.common.dal.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.service.IService;
import com.bxm.lovelink.common.dal.entity.UserBasicInfo;
import com.bxm.lovelink.common.dal.entity.UserComposite;
import com.bxm.lovelink.common.dal.entity.dto.user.UserBasicInfoDto;
import com.bxm.lovelink.common.dal.entity.dto.user.UserQueryDto;
import com.bxm.lovelink.common.dal.entity.vo.user.UserCompositeVo;

import java.time.LocalDateTime;
import java.util.List;

/**
 * <p>
 * 用户的基本信息 服务类
 * </p>
 *
 * @author zhangdong
 * @since 2025-05-15
 */
public interface IUserBasicInfoService extends IService<UserBasicInfo> {
    UserBasicInfo getOneByUserId(Long userId);

    void updateByDto(UserBasicInfoDto dto, UserComposite composite);

    boolean updateAndCalculateById(UserBasicInfo entity);

    /**
     * 更新用户的vip到期时间
     *
     * @param userId    用户id
     * @param validDays vip有效天数
     */
    void updateVipExpireTime(Long userId, int validDays);

    LocalDateTime computeVipExpireTime(Long userId, int validDays);

    IPage<UserCompositeVo> list(UserQueryDto dto);

    List<UserBasicInfo> listByUserIds(List<Long> userIds);

    List<UserBasicInfo> listIncludeDeleted(List<Long> userIds);
}
