package com.bxm.lovelink.common.dal.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.bxm.lovelink.common.dal.entity.UserMeetTicket;
import com.bxm.lovelink.common.dal.entity.dto.meetticket.ReturnTicketOperateDto;
import com.bxm.lovelink.common.dal.entity.dto.meetticket.TicketFinishGiveOperateDto;
import com.bxm.lovelink.common.dal.entity.dto.meetticket.TicketOperateDto;

import java.util.List;

/**
 * <p>
 * 用户红豆 服务类
 * </p>
 *
 * @author tangxiao
 * @since 2025-05-15
 */
public interface IUserMeetTicketService extends IService<UserMeetTicket> {

    /**
     * 充值红豆
     */
    void rechargeTicket(TicketOperateDto dto);

    /**
     * 赠送红豆
     */
    void giveTicket(TicketFinishGiveOperateDto dto);

    /**
     * 使用红豆
     * @return 本次使用的红豆id
     */
    List<Long> useTicket(TicketOperateDto dto);

    /**
     * 退回红豆
     */
    void returnTicket(ReturnTicketOperateDto dto);

    /**
     * 获取用户可用红豆列表
     */
    List<UserMeetTicket> listAvailableTicket(Long userId);

    /**
     * 统计用户剩余红豆数量
     */
    int getUserRemainAmount(Long userId);

}
