package com.bxm.lovelink.common.dal.service;

import com.bxm.lovelink.common.dal.entity.MeetTicketProduct;
import com.bxm.lovelink.common.dal.entity.UserOrder;
import com.baomidou.mybatisplus.extension.service.IService;
import com.bxm.lovelink.common.dal.entity.dto.order.CreateOrderDto;
import com.bxm.lovelink.common.dal.entity.dto.order.PrepayDto;
import com.bxm.lovelink.integration.apple.ApplePayIntegration;

import java.math.BigDecimal;
import java.util.List;

/**
 * <p>
 * 用户订单表 服务类
 * </p>
 *
 * @author tangxiao
 * @since 2025-05-15
 */
public interface IUserOrderService extends IService<UserOrder> {

    /**
     * 查询订单
     * @param orderNum 订单号
     * @return 可能null
     */
    UserOrder query(String orderNum);

    String createOrder(CreateOrderDto dto, Long userId);

    Object prepay(PrepayDto prepayDto);

    void delivery(String orderNum, String tradeNum, BigDecimal amount);

    void refundCallback(String orderNum, Boolean result);

    /**
     * 发起退款
     * @param id
     */
    void refund(Long id);


    /**
     * 充值订单数量
     * @param userId
     * @return
     */
    int rechargeOrderCount(Long userId);

    boolean existsByTransactionId(String transactionId);

    UserOrder createIapOrder(Long userId, MeetTicketProduct product, ApplePayIntegration.VerifyReceiptResponse.InApp transaction);

    UserOrder queryByTransactionId(String transactionId);

    List<UserOrder> getPendingIapOrders();
}
