package com.bxm.lovelink.common.dal.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.bxm.lovelink.common.dal.entity.User;
import com.bxm.lovelink.common.dal.entity.UserComposite;
import com.bxm.lovelink.common.dal.entity.dto.user.UserCompositeDto;
import com.bxm.lovelink.common.dal.entity.vo.user.UserCompositeVo;

import java.util.List;

/**
 * <p>
 * 用户账号信息 服务类
 * </p>
 *
 * @author zhangdong
 * @since 2025-05-15
 */
public interface IUserService extends IService<User> {

    UserComposite getCompositeById(Long id);

    UserComposite getCompositeByUserNumber(String userNumber);

    List<UserComposite> getCompositePartByUserIdsFromCache(List<Long> userIds);

    Long createUser(User user);

    void registerMobile(Long userId, String mobile);

    UserCompositeVo getCompositeVoById(Long id);

    UserCompositeVo getCompositeVoByUserNumber(String userNumber);

    UserCompositeVo convert(UserComposite composite);

    List<UserCompositeVo> convert(List<UserComposite> composite);

    void updateByCompositeDto(UserCompositeDto dto, UserComposite composite);

    void cancel(UserComposite userComposite, String reason);

}
