package com.bxm.lovelink.common.dal.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.bxm.lovelink.common.dal.entity.UserTag;
import com.bxm.lovelink.common.dal.entity.vo.user.UserTagVo;

import java.util.List;
import java.util.Map;
import java.util.function.Function;

/**
 * <p>
 * 标签 服务类
 * </p>
 *
 * @author zhangdong
 * @since 2025-05-15
 */
public interface IUserTagService extends IService<UserTag> {

    List<UserTagVo> listByRootChildren(Integer type);

    UserTagVo listByRoot(Integer type);

    /**
     * 优先从缓存里获取所有的标签信息
     * @param valueMapper 缓存值映射
     * @param <U> 缓存值类型
     * @return 标签ID映射
     */
    <U> Map<Long, U> fetchAll(Function<UserTag, U> valueMapper);

}
