package com.bxm.lovelink.common.dal.service;

import com.bxm.lovelink.common.dal.entity.dto.meet.VirtualPhoneNumberBindResult;

/**
 * 虚拟电话号码服务
 *
 * @author huxiao
 */
public interface VirtualPhoneNumberService {

    /**
     * 重新绑定号码。在绑定之前先解绑，如果有的话。
     *
     * @param a A用户
     * @param b B用户
     * @return 虚拟号码
     */
    VirtualPhoneNumberBindResult rebind(String a, String b);

    /**
     * 绑定号码
     *
     * @param a A用户
     * @param b B用户
     * @return 虚拟号码
     */
    VirtualPhoneNumberBindResult bind(String a, String b);

    /**
     * 解绑号码
     *
     * @param subscriptionId 关联ID
     */
    void unbind(String subscriptionId);
}
