package com.bxm.lovelink.common.dal.service.impl;

import com.bxm.lovelink.common.dal.entity.dto.meet.VirtualPhoneNumberBindResult;
import com.bxm.lovelink.common.dal.service.VirtualPhoneNumberService;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.cache.Updater;
import com.bxm.warcar.utils.KeyBuilder;
import org.apache.commons.lang3.StringUtils;

import java.time.Duration;

/**
 * @author Allen Hu
 * @date 2025/5/19
 */
public abstract class AbstractVirtualPhoneNumberService implements VirtualPhoneNumberService {

    private final Fetcher fetcher;
    private final Updater updater;

    protected AbstractVirtualPhoneNumberService(Fetcher fetcher, Updater updater) {
        this.fetcher = fetcher;
        this.updater = updater;
    }

    protected int getExpireTimeInSecond() {
        return (int) Duration.ofMinutes(10).getSeconds();
    }

    @Override
    public VirtualPhoneNumberBindResult rebind(String a, String b) {
        KeyGenerator aKey = () -> KeyBuilder.build("lovelink", "virtual", "bind", a);
        VirtualPhoneNumberBindResult bindResultA = fetcher.fetch(aKey, VirtualPhoneNumberBindResult.class);
        String subscriptionIdA = null;
        if (null != bindResultA) {
            subscriptionIdA = bindResultA.getSubscriptionId();
            this.unbind(subscriptionIdA);
        }

        KeyGenerator bKey = () -> KeyBuilder.build("lovelink", "virtual", "bind", b);
        VirtualPhoneNumberBindResult bindResultB = fetcher.fetch(bKey, VirtualPhoneNumberBindResult.class);
        if (null != bindResultB && !StringUtils.equals(subscriptionIdA, bindResultB.getSubscriptionId())) {
            String subscriptionId = bindResultB.getSubscriptionId();
            this.unbind(subscriptionId);
        }

        VirtualPhoneNumberBindResult bindResult = this.bind(a, b);
        int expireTimeInSecond = getExpireTimeInSecond();
        updater.update(aKey, bindResult, expireTimeInSecond);
        updater.update(bKey, bindResult, expireTimeInSecond);

        return bindResult;
    }
}
