package com.bxm.lovelink.common.dal.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.bxm.lovelink.common.dal.entity.ActivityEvaluation;
import com.bxm.lovelink.common.dal.entity.dto.activity.evaluation.ActivityEvaluationDto;
import com.bxm.lovelink.common.dal.mapper.ActivityEvaluationMapper;
import com.bxm.lovelink.common.dal.mapping.activity.ActivityEvaluationMapping;
import com.bxm.lovelink.common.dal.service.IActivityEvaluationService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.IntSummaryStatistics;
import java.util.List;
import java.util.Objects;

/**
 * <p>
 * 活动用户评价表 服务实现类
 * </p>
 *
 * @author dll
 * @since 2025-06-23
 */
@Service
public class ActivityEvaluationServiceImpl extends ServiceImpl<ActivityEvaluationMapper, ActivityEvaluation> implements IActivityEvaluationService {
    @Override
    public void submitEvaluation(ActivityEvaluationDto dto, Long userId) {
        if (Objects.isNull(dto)){
            throw new IllegalArgumentException("评价信息不能为空");
        }
        ActivityEvaluation activityEvaluation = baseMapper.selectOne(new LambdaQueryWrapper<ActivityEvaluation>().eq(ActivityEvaluation::getActivityId, dto.getActivityId()).eq(ActivityEvaluation::getUserId, userId));
        if (Objects.nonNull(activityEvaluation)){
            throw new IllegalArgumentException("已经评价过该活动");
        }
        dto.validateEvaluation();
        ActivityEvaluation evaluation = ActivityEvaluationMapping.INSTANCE.dtoToDo(dto);
        evaluation.setUserId(userId);
        List<Integer> scores = Arrays.asList(
                dto.getHostScore(),
                dto.getContentScore(),
                dto.getGuestQualityScore(),
                dto.getCostScore(),
                dto.getOverallScore()
        );

        IntSummaryStatistics statistics = scores.stream()
                .filter(Objects::nonNull)
                .mapToInt(Integer::intValue)
                .summaryStatistics();
        if (statistics.getCount() != 0) {
            evaluation.setAvgScore(BigDecimal.valueOf(statistics.getSum())
                    .divide(BigDecimal.valueOf(statistics.getCount()), 2, RoundingMode.HALF_UP));
        }
        baseMapper.insert(evaluation);
    }
}
