package com.bxm.lovelink.common.dal.service.impl;

import com.bxm.lovelink.common.contant.Constants;
import com.bxm.lovelink.common.dal.entity.ActivityType;
import com.bxm.lovelink.common.dal.mapper.ActivityTypeMapper;
import com.bxm.lovelink.common.dal.service.IActivityTypeService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.stereotype.Service;

import java.util.Objects;

/**
 * <p>
 * 活动类型表 服务实现类
 * </p>
 *
 * @author dll
 * @since 2025-06-23
 */
@Service
public class ActivityTypeServiceImpl extends ServiceImpl<ActivityTypeMapper, ActivityType> implements IActivityTypeService {

    @Override
    public Boolean supportMutualSelection(Long activityTypeId) {
        ActivityType activityType = getById(activityTypeId);
        if (Objects.nonNull(activityType) && activityType.getBizType().equals(Constants.ActivityBizType.MUTUAL_SELECTION)){
            return true;
        }
        return false;
    }
}
