package com.bxm.lovelink.common.dal.service.impl;

import com.bxm.lovelink.common.dal.entity.vo.file.FileUploadResultVo;
import com.bxm.lovelink.common.dal.service.FileService;
import com.bxm.warcar.file.upload.HttpFileManager;
import com.bxm.warcar.file.upload.HttpFileRequest;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.DigestUtils;
import org.springframework.web.multipart.MultipartFile;

import java.util.Objects;

/**
 * 文件管理服务实现类
 */
@Slf4j
@Service
public class FileServiceImpl implements FileService {
    @Autowired
    private HttpFileManager httpFileManager;

    @Override
    public FileUploadResultVo upload(MultipartFile file) {
        if (Objects.isNull(file)) {
            throw new IllegalArgumentException("文件不能为空");
        }
        FileUploadResultVo fileUploadResultVo = new FileUploadResultVo();
        try {
            byte[] bytes = file.getBytes();
            String md5 = DigestUtils.md5DigestAsHex(bytes);
            fileUploadResultVo.setMd5(md5);
            String url = httpFileManager.upload(new HttpFileRequest(file));
            fileUploadResultVo.setUrl(url);
        } catch (Exception e) {
            log.error("上传文件失败", e);
            throw new IllegalArgumentException("上传失败");
        }
        return fileUploadResultVo;
    }
}
