package com.bxm.lovelink.common.dal.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bxm.lovelink.common.dal.entity.MeetGroupMessage;
import com.bxm.lovelink.common.dal.entity.dao.MeetGroupMessageMaxId;
import com.bxm.lovelink.common.dal.entity.dao.MeetGroupUnreadMessageCountDao;
import com.bxm.lovelink.common.dal.mapper.MeetGroupMessageMapper;
import com.bxm.lovelink.common.dal.service.IMeetGroupMessageService;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Optional;

/**
 * <p>
 * 见面群聊天记录 服务实现类
 * </p>
 *
 * @author allen
 * @since 2025-05-13
 */
@Service
public class MeetGroupMessageServiceImpl extends ServiceImpl<MeetGroupMessageMapper, MeetGroupMessage> implements IMeetGroupMessageService {
    @Override
    public List<MeetGroupMessage> queryNewMessages(Long userId, Long meetGroupId) {
        // TODO 后续可以考虑使用 Redis 队列来存储，提高查询速度。
        return baseMapper.queryNewMessages(userId, meetGroupId);
    }

    @Override
    public List<MeetGroupUnreadMessageCountDao> countUnreadOnMessages(Long userId, Long[] meetGroupIds) {
        return baseMapper.countUnreadOnMessages(userId, meetGroupIds);
    }

    @Override
    public int countUnreadOnMeetGroup(Long userId) {
        return Optional.ofNullable(baseMapper.countUnreadOnMeetGroup(userId)).orElse(0);
    }

    @Override
    public List<MeetGroupMessageMaxId> queryMaxIdOnMeetGroup(Long[] meetGroupIds) {
        return baseMapper.queryMaxIdOnMeetGroup(meetGroupIds);
    }
}
