package com.bxm.lovelink.common.dal.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bxm.lovelink.common.dal.entity.MeetGroup;
import com.bxm.lovelink.common.dal.entity.dao.MeetGroupDao;
import com.bxm.lovelink.common.dal.mapper.MeetGroupMapper;
import com.bxm.lovelink.common.dal.service.IMeetGroupService;
import org.springframework.stereotype.Service;

import java.io.Serializable;
import java.util.List;

/**
 * <p>
 * 见面群 服务实现类
 * </p>
 *
 * @author allen
 * @since 2025-05-13
 */
@Service
public class MeetGroupServiceImpl extends ServiceImpl<MeetGroupMapper, MeetGroup> implements IMeetGroupService {

    @Override
    public MeetGroupDao getDaoById(Serializable id) {
        return getBaseMapper().selectDaoById(id);
    }

    @Override
    public List<MeetGroupDao> listDao(Wrapper<MeetGroup> queryWrapper) {
        return getBaseMapper().selectDaoList(queryWrapper);
    }

    @Override
    public MeetGroupDao getDaoOne(Wrapper<MeetGroup> queryWrapper) {
        return getBaseMapper().selectDaoOne(queryWrapper);
    }

    @Override
    public List<MeetGroup> queryAll(Long inviteUserId) {
        QueryWrapper<MeetGroup> queryWrapper = Wrappers.query(new MeetGroup().setInviteUserId(inviteUserId));
        return list(queryWrapper);
    }
}
