package com.bxm.lovelink.common.dal.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.bxm.lovelink.common.dal.entity.MeetTicketProduct;
import com.bxm.lovelink.common.dal.mapper.MeetTicketProductMapper;
import com.bxm.lovelink.common.dal.service.IMeetTicketProductService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.stereotype.Service;

/**
 * <p>
 * 红豆商品 服务实现类
 * </p>
 *
 * @author tangxiao
 * @since 2025-05-15
 */
@Service
public class MeetTicketProductServiceImpl extends ServiceImpl<MeetTicketProductMapper, MeetTicketProduct> implements IMeetTicketProductService {

    @Override
    public MeetTicketProduct getByAppleProductId(String appleProductId) {
        return getOne(new LambdaQueryWrapper<MeetTicketProduct>().eq(MeetTicketProduct::getAppleProductId, appleProductId));
    }
}
